--[[---------------------------------------------------------------------------
	Chocolatier Two Port Data: San Francisco
	Copyright (c) 2007 Big Splash Games, LLC. All Rights Reserved.
--]]---------------------------------------------------------------------------

-------------------------------------------------------------------------------
-- Characters

DefineCharacter { name = "sf_factorykeep" }
DefineCharacter { name = "sf_marketkeep" }
DefineCharacter { name = "sf_shopkeep" }
DefineCharacter { name = "sf_barkeep" }
DefineCharacter { name = "sf_tutor" }
DefineCharacter { name = "sf_bchqkeep" }

-------------------------------------------------------------------------------
-- Port Definition

DefinePort
{
	name = "sanfrancisco",
	available = false,
	ambient = "sfx/metropolitan_loop.ogg",
	
	layout =
	{
		SpriteLayer { image="sf_bridge_construction", x=84,y=99, startweek=440, endweek=636, },
		SpriteLayer { image="sf_bridge", x=84,y=99, startweek=637,},

		-- Airship
		SpriteLayer { image="aircraft_02", time=30000, scale=.3, hold=10000, random=30,
			near = 230, nearscale=1,farscale=.2,
			path={{-80,1},{133,230},{547,38},{889,0},}, },
			
		-- Clouds
		SpriteLayer { image="clouds_01", time=210000, loop=true, path={{0,50},{100,50},{700,50},{800,50}}, },
		
		-- Plane
		SpriteLayer { imagelist=portPlanes, time=5000, scale=.25, hold=8000, random=60,
			path={{-91,67},{91,78},{302,81},{549,76},{657,75},{761,65},{897,53},},	},
		
		Fireworks(),
		
		-- Ships
		SpriteLayer { imagelist=portBoats, time=120000, scale=.2, bounce=true, hold=5000, random=40,
			path={{-83,175},{234,180},{586,181},{877,175},}, },
		SpriteLayer { imagelist=portBoats, time=95000, scale=.2, bounce=true, hold=3000, random=80,
			path={{875,183},{631,189},{573,178},{279,179},{195,177},{80,181},{-93,183},}, },
			
		SpriteLayer { image="sf_bridge_construction_front", x=72,y=99, startweek=629, endweek=629+52, },
		SpriteLayer { image="sf_bridge_front", x=69,y=99, startweek=629+52+1, },

		SpriteLayer { image="sf_bridge_mask", x=155,y=173, },
		
		Market { name="sf_market", character="sf_marketkeep", x=575,y=194,		--x=598,y=193,
			inventory = { sugar=true, milk=true, almond=true, raspberry = true,} },
		
		--Sideways Cars
		SpriteLayer { imagelist=portCars, time=3000, scale=.2, bounce=true, hold=3000, random=80,
			path={{477,262},{517,262},{603,262},{650,262},}, },
			
		SpriteLayer { imagelist=portCars, time=2800, scale=.22, bounce=true, hold=150, random=70,
			path={{477,270},{517,270},{603,270},{650,270},}, },
			
		SpriteLayer { imagelist=portCars, time=2700, scale=.24, bounce=true, hold=4550, random=60,
			path={{477,275},{517,275},{603,275},{650,275},}, },
			
		Shop { name="sf_shop", character="sf_shopkeep", x=646,y=271, },	--labelx=670,labely=299, },
		EmptyBuilding { name="sf_bar", character= {"sf_barkeep"}, ambient="sfx/saloon_loop.ogg", x=731,y=238, labelx=700,labely=200, },
		Factory { name="sf_factory", character="sf_factorykeep", x=171,y=271, },
		SpriteLayer { image="sf_factory_mask", x=176,y=326, },
		PlayerLogo { name="logo", x=195,y=234, scale=0.35, target="sf_factory" },
		
		-- Cars, streetcars
		SpriteLayer { image="car_07", time=10000, near=415, nearscale=.2,farscale=.1, hold=2000,
			path={{895,599},{768,483},{457,173},{489,235},}, },
		SpriteLayer { image="train_04A", time=15000, near=415, nearscale=.2,farscale=.1, hold=5000,
			path={{487,218},{557,306},{754,530},{840,625},}, },
		SpriteLayer { image="car_07", time=10000, near=415, nearscale=.2,farscale=.1, hold=1500,
			path={{739,644},{675,545},{520,311},{469,233},}, },
		
		Speakeasy { name="sf_bchq", x=299+236/2,y=150+245/2, labelx=360,labely=252, 
		rank0 = {"sf_tutor"},
		rank3 = {"sf_bchqkeep", "syd_other2keep"},
		rank5 = {"sf_tutor", "sf_bchqkeep", "syd_other2keep"},
		},
		SpriteLayer { image="sf_sign_scaffold", x=341+175/2,y=55+100/2, },
		BaumeisterSign { name="bcsign", x=341+175/2,y=55+100/2, w=175,h=100 },
		
		SpriteLayer { image="sf_bar_mask", x=794,y=389, },
		

-- not necessary -- this area masked by UI
--		SpriteLayer { image="sf_bchq_mask", x=251+330/2,y=406+136/2, },
	},
}
